"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SAPOdataSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
class SAPOdataSource {
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.SAPOdataConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        return {
            sapoData: {
                objectPath: this.props.object,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.SAPOdataSource = SAPOdataSource;
_a = JSII_RTTI_SYMBOL_1;
SAPOdataSource[_a] = { fqn: "@cdklabs/cdk-appflow.SAPOdataSource", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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