"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SAPOdataConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_profile_1 = require("../core/connectors/connector-profile");
class SAPOdataConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, {
            arn,
        });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, {
            name,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.SAPOdataConnectorType.instance);
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        let sapOdata = {};
        if (properties.basicAuth) {
            sapOdata.basicAuthCredentials = {
                username: properties.basicAuth.username,
                password: properties.basicAuth.password.unsafeUnwrap(),
            };
        }
        else if (properties.oAuth) {
            sapOdata.oAuthCredentials = {
                accessToken: properties.oAuth.accessToken?.unsafeUnwrap(),
                refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken?.unsafeUnwrap(),
                clientId: properties.oAuth.flow?.refreshTokenGrant.clientId?.unsafeUnwrap(),
                clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret?.unsafeUnwrap(),
            };
        }
        return {
            sapoData: sapOdata,
        };
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            sapoData: {
                applicationHostUrl: properties.applicationHostUrl,
                applicationServicePath: properties.applicationServicePath,
                portNumber: properties.portNumber,
                clientNumber: properties.clientNumber,
                logonLanguage: properties.logonLanguage,
            },
        };
    }
}
exports.SAPOdataConnectorProfile = SAPOdataConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
SAPOdataConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.SAPOdataConnectorProfile", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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