import { SecretValue } from "aws-cdk-lib";
import { CfnConnectorProfile } from "aws-cdk-lib/aws-appflow";
import { Construct } from "constructs";
import { ConnectorProfileBase, ConnectorProfileProps } from "../core/connectors/connector-profile";
export interface SAPOdataConnectorProfileProps extends ConnectorProfileProps {
    readonly basicAuth?: SAPOdataBasicAuthSettings;
    readonly oAuth?: SAPOdataOAuthSettings;
    readonly applicationHostUrl: string;
    readonly applicationServicePath: string;
    readonly portNumber?: number;
    readonly clientNumber: string;
    readonly logonLanguage: string;
}
export interface SAPOdataBasicAuthSettings {
    readonly username: string;
    readonly password: SecretValue;
}
export interface SAPOdataOAuthEndpoints {
    readonly token: string;
}
export interface SAPOdataOAuthRefreshTokenGrantFlow {
    readonly refreshToken?: SecretValue;
    readonly clientId: SecretValue;
    readonly clientSecret: SecretValue;
}
export interface SAPOdataOAuthFlows {
    readonly refreshTokenGrant: SAPOdataOAuthRefreshTokenGrantFlow;
}
export interface SAPOdataOAuthSettings {
    readonly accessToken?: SecretValue;
    readonly flow?: SAPOdataOAuthFlows;
    readonly endpoints?: SAPOdataOAuthEndpoints;
}
export declare class SAPOdataConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): SAPOdataConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): SAPOdataConnectorProfile;
    constructor(scope: Construct, id: string, props: SAPOdataConnectorProfileProps);
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
    protected buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
}
