"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SAPOdataDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
class SAPOdataDestination {
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.SAPOdataConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.errorHandling?.errorLocation?.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        this.tryAddNodeDependency(flow, this.props.profile);
        this.tryAddNodeDependency(flow, this.props.successResponseHandling?.location.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.successResponseHandling?.location.bucket);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            sapoData: {
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling.failOnFirstError,
                },
                successResponseHandlingConfig: this.props.successResponseHandling
                    ?.location && {
                    bucketName: this.props.successResponseHandling.location.bucket.bucketName,
                },
                idFieldNames: this.props.operation.ids,
                objectPath: this.props.object,
                writeOperationType: this.props.operation.type,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.SAPOdataDestination = SAPOdataDestination;
_a = JSII_RTTI_SYMBOL_1;
SAPOdataDestination[_a] = { fqn: "@cdklabs/cdk-appflow.SAPOdataDestination", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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