"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesforceSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
class SalesforceSource {
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.SalesforceConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            apiVersion: this.props.apiVersion,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        return {
            salesforce: {
                dataTransferApi: this.props.dataTransferApi,
                enableDynamicFieldUpdate: this.props.enableDynamicFieldUpdate,
                includeDeletedRecords: this.props.includeDeletedRecords,
                object: this.props.object,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.SalesforceSource = SalesforceSource;
_a = JSII_RTTI_SYMBOL_1;
SalesforceSource[_a] = { fqn: "@cdklabs/cdk-appflow.SalesforceSource", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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