"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesforceConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_profile_1 = require("../core/connectors/connector-profile");
class SalesforceConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, {
            arn,
        });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, {
            name,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.SalesforceConnectorType.instance);
        this.tryAddNodeDependency(this, props.oAuth.flow?.refreshTokenGrant?.client);
    }
    buildConnectorProfileProperties(properties) {
        const props = properties;
        return {
            salesforce: {
                isSandboxEnvironment: props.isSandbox,
                instanceUrl: props.instanceUrl,
            },
        };
    }
    buildConnectorProfileCredentials(properties) {
        const props = properties;
        let salesforce = {};
        salesforce.accessToken = props.oAuth.accessToken?.unsafeUnwrap();
        const refreshTokenGrant = props.oAuth.flow?.refreshTokenGrant;
        salesforce.refreshToken =
            refreshTokenGrant?.refreshToken?.unsafeUnwrap() ?? "dummyRefreshToken";
        if (refreshTokenGrant?.client) {
            salesforce.clientCredentialsArn = refreshTokenGrant.client.secretArn;
            // TODO: make sure why this doesn't work.
            //       this doc says it should: https://docs.aws.amazon.com/appflow/latest/userguide/salesforce.html
            //       in order to obtain the access token I needed to follow: https://medium.com/@bpmmendis94/obtain-access-refresh-tokens-from-salesforce-rest-api-a324fe4ccd9b
            salesforce.accessToken = salesforce.accessToken ?? "dummyAccessToken";
        }
        return {
            salesforce: salesforce,
        };
    }
}
exports.SalesforceConnectorProfile = SalesforceConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
SalesforceConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.SalesforceConnectorProfile", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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