"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesforceDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
class SalesforceDestination {
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.SalesforceConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.errorHandling?.errorLocation?.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        this.tryAddNodeDependency(flow, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            salesforce: {
                dataTransferApi: this.props.dataTransferApi,
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling.failOnFirstError,
                },
                idFieldNames: this.props.operation.ids,
                object: this.props.object,
                writeOperationType: this.props.operation.type,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.SalesforceDestination = SalesforceDestination;
_a = JSII_RTTI_SYMBOL_1;
SalesforceDestination[_a] = { fqn: "@cdklabs/cdk-appflow.SalesforceDestination", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVzdGluYXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvc2FsZXNmb3JjZS9kZXN0aW5hdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQVFBLGlDQUFpRDtBQUNqRCxxRkFBZ0Y7QUE0QmhGLE1BQWEscUJBQXFCO0lBSWhDLFlBQTZCLEtBQWlDO1FBQWpDLFVBQUssR0FBTCxLQUFLLENBQTRCO1FBSDlDLGtCQUFhLEdBQzNCLDhCQUF1QixDQUFDLFFBQVEsQ0FBQztJQUU4QixDQUFDO0lBRWxFLElBQUksQ0FBQyxJQUFXO1FBQ2QsSUFBSSxDQUFDLG9CQUFvQixDQUN2QixJQUFJLEVBQ0osSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLEVBQUUsYUFBYSxFQUFFLE1BQU0sQ0FDaEQsQ0FBQztRQUNGLHVEQUF5QixDQUFDLFFBQVEsRUFBRSxDQUFDLGdCQUFnQixDQUNuRCxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsRUFBRSxhQUFhLEVBQUUsTUFBTSxDQUNoRCxDQUFDO1FBQ0YsSUFBSSxDQUFDLG9CQUFvQixDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBRXBELE9BQU87WUFDTCxhQUFhLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxzQkFBc0I7WUFDeEQsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsSUFBSTtZQUM3Qyw4QkFBOEIsRUFDNUIsSUFBSSxDQUFDLG1DQUFtQyxFQUFFO1NBQzdDLENBQUM7SUFDSixDQUFDO0lBRU8sbUNBQW1DO1FBQ3pDLE9BQU87WUFDTCxVQUFVLEVBQUU7Z0JBQ1YsZUFBZSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsZUFBZTtnQkFDM0MsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLElBQUk7b0JBQy9DLFVBQVUsRUFDUixJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsRUFBRSxhQUFhLEVBQUUsTUFBTSxDQUFDLFVBQVU7b0JBQzVELFlBQVksRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsRUFBRSxhQUFhLEVBQUUsTUFBTTtvQkFDN0QsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUMsZ0JBQWdCO2lCQUM1RDtnQkFDRCxZQUFZLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUMsR0FBRztnQkFDdEMsTUFBTSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTTtnQkFDekIsa0JBQWtCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUMsSUFBSTthQUM5QztTQUNGLENBQUM7SUFDSixDQUFDO0lBRU8sb0JBQW9CLENBQzFCLEtBQWlCLEVBQ2pCLFFBQThCO1FBRTlCLElBQUksUUFBUSxJQUFJLE9BQU8sUUFBUSxLQUFLLFFBQVEsRUFBRSxDQUFDO1lBQzdDLEtBQUssQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3JDLENBQUM7SUFDSCxDQUFDOztBQWhESCxzREFpREMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmbkZsb3cgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWFwcGZsb3dcIjtcbmltcG9ydCB7IElDb25zdHJ1Y3QgfSBmcm9tIFwiY29uc3RydWN0c1wiO1xuaW1wb3J0IHsgU2FsZXNmb3JjZUNvbm5lY3RvclByb2ZpbGUgfSBmcm9tIFwiLi9wcm9maWxlXCI7XG5pbXBvcnQgeyBTYWxlc2ZvcmNlRGF0YVRyYW5zZmVyQXBpIH0gZnJvbSBcIi4vc2FsZXNmb3JjZS1kYXRhLXRyYW5zZmVyLWFwaVwiO1xuaW1wb3J0IHsgU2FsZXNmb3JjZUNvbm5lY3RvclR5cGUgfSBmcm9tIFwiLi90eXBlXCI7XG5pbXBvcnQgeyBBcHBGbG93UGVybWlzc2lvbnNNYW5hZ2VyIH0gZnJvbSBcIi4uL2NvcmUvYXBwZmxvdy1wZXJtaXNzaW9ucy1tYW5hZ2VyXCI7XG5pbXBvcnQgeyBDb25uZWN0b3JUeXBlIH0gZnJvbSBcIi4uL2NvcmUvY29ubmVjdG9ycy9jb25uZWN0b3ItdHlwZVwiO1xuaW1wb3J0IHsgRXJyb3JIYW5kbGluZ0NvbmZpZ3VyYXRpb24gfSBmcm9tIFwiLi4vY29yZS9lcnJvci1oYW5kbGluZ1wiO1xuaW1wb3J0IHsgSUZsb3cgfSBmcm9tIFwiLi4vY29yZS9mbG93c1wiO1xuaW1wb3J0IHsgSURlc3RpbmF0aW9uIH0gZnJvbSBcIi4uL2NvcmUvdmVydGljZXMvZGVzdGluYXRpb25cIjtcbmltcG9ydCB7IFdyaXRlT3BlcmF0aW9uIH0gZnJvbSBcIi4uL2NvcmUvd3JpdGUtb3BlcmF0aW9uXCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgU2FsZXNmb3JjZURlc3RpbmF0aW9uUHJvcHMge1xuICByZWFkb25seSBwcm9maWxlOiBTYWxlc2ZvcmNlQ29ubmVjdG9yUHJvZmlsZTtcblxuICAvKipcbiAgICogU3BlY2lmaWVzIHdoaWNoIFNhbGVzZm9yY2UgQVBJIGlzIHVzZWQgYnkgQW1hem9uIEFwcEZsb3cgd2hlbiB5b3VyIGZsb3cgdHJhbnNmZXJzIGRhdGEgdG8gU2FsZXNmb3JjZS5cbiAgICovXG4gIHJlYWRvbmx5IGRhdGFUcmFuc2ZlckFwaT86IFNhbGVzZm9yY2VEYXRhVHJhbnNmZXJBcGk7XG5cbiAgLyoqXG4gICAqIFRoZSBzZXR0aW5ncyB0aGF0IGRldGVybWluZSBob3cgQW1hem9uIEFwcEZsb3cgaGFuZGxlcyBhbiBlcnJvciB3aGVuIHBsYWNpbmcgZGF0YSBpbiB0aGUgU2FsZXNmb3JjZSBkZXN0aW5hdGlvbi4gRm9yIGV4YW1wbGUsIHRoaXMgc2V0dGluZyB3b3VsZCBkZXRlcm1pbmUgaWYgdGhlIGZsb3cgc2hvdWxkIGZhaWwgYWZ0ZXIgb25lIGluc2VydGlvbiBlcnJvciwgb3IgY29udGludWUgYW5kIGF0dGVtcHQgdG8gaW5zZXJ0IGV2ZXJ5IHJlY29yZCByZWdhcmRsZXNzIG9mIHRoZSBpbml0aWFsIGZhaWx1cmUuXG4gICAqL1xuICByZWFkb25seSBlcnJvckhhbmRsaW5nPzogRXJyb3JIYW5kbGluZ0NvbmZpZ3VyYXRpb247XG5cbiAgLyoqXG4gICAqIFRoZSBTYWxlc2ZvcmNlIG9iamVjdCBmb3Igd2hpY2ggdGhlIG9wZXJhdGlvbiBpcyB0byBiZSBzZXQuXG4gICAqL1xuICByZWFkb25seSBvYmplY3Q6IHN0cmluZztcblxuICByZWFkb25seSBvcGVyYXRpb246IFdyaXRlT3BlcmF0aW9uO1xufVxuXG5leHBvcnQgY2xhc3MgU2FsZXNmb3JjZURlc3RpbmF0aW9uIGltcGxlbWVudHMgSURlc3RpbmF0aW9uIHtcbiAgcHVibGljIHJlYWRvbmx5IGNvbm5lY3RvclR5cGU6IENvbm5lY3RvclR5cGUgPVxuICAgIFNhbGVzZm9yY2VDb25uZWN0b3JUeXBlLmluc3RhbmNlO1xuXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IFNhbGVzZm9yY2VEZXN0aW5hdGlvblByb3BzKSB7fVxuXG4gIGJpbmQoZmxvdzogSUZsb3cpOiBDZm5GbG93LkRlc3RpbmF0aW9uRmxvd0NvbmZpZ1Byb3BlcnR5IHtcbiAgICB0aGlzLnRyeUFkZE5vZGVEZXBlbmRlbmN5KFxuICAgICAgZmxvdyxcbiAgICAgIHRoaXMucHJvcHMuZXJyb3JIYW5kbGluZz8uZXJyb3JMb2NhdGlvbj8uYnVja2V0LFxuICAgICk7XG4gICAgQXBwRmxvd1Blcm1pc3Npb25zTWFuYWdlci5pbnN0YW5jZSgpLmdyYW50QnVja2V0V3JpdGUoXG4gICAgICB0aGlzLnByb3BzLmVycm9ySGFuZGxpbmc/LmVycm9yTG9jYXRpb24/LmJ1Y2tldCxcbiAgICApO1xuICAgIHRoaXMudHJ5QWRkTm9kZURlcGVuZGVuY3koZmxvdywgdGhpcy5wcm9wcy5wcm9maWxlKTtcblxuICAgIHJldHVybiB7XG4gICAgICBjb25uZWN0b3JUeXBlOiB0aGlzLmNvbm5lY3RvclR5cGUuYXNQcm9maWxlQ29ubmVjdG9yVHlwZSxcbiAgICAgIGNvbm5lY3RvclByb2ZpbGVOYW1lOiB0aGlzLnByb3BzLnByb2ZpbGUubmFtZSxcbiAgICAgIGRlc3RpbmF0aW9uQ29ubmVjdG9yUHJvcGVydGllczpcbiAgICAgICAgdGhpcy5idWlsZERlc3RpbmF0aW9uQ29ubmVjdG9yUHJvcGVydGllcygpLFxuICAgIH07XG4gIH1cblxuICBwcml2YXRlIGJ1aWxkRGVzdGluYXRpb25Db25uZWN0b3JQcm9wZXJ0aWVzKCk6IENmbkZsb3cuRGVzdGluYXRpb25Db25uZWN0b3JQcm9wZXJ0aWVzUHJvcGVydHkge1xuICAgIHJldHVybiB7XG4gICAgICBzYWxlc2ZvcmNlOiB7XG4gICAgICAgIGRhdGFUcmFuc2ZlckFwaTogdGhpcy5wcm9wcy5kYXRhVHJhbnNmZXJBcGksXG4gICAgICAgIGVycm9ySGFuZGxpbmdDb25maWc6IHRoaXMucHJvcHMuZXJyb3JIYW5kbGluZyAmJiB7XG4gICAgICAgICAgYnVja2V0TmFtZTpcbiAgICAgICAgICAgIHRoaXMucHJvcHMuZXJyb3JIYW5kbGluZz8uZXJyb3JMb2NhdGlvbj8uYnVja2V0LmJ1Y2tldE5hbWUsXG4gICAgICAgICAgYnVja2V0UHJlZml4OiB0aGlzLnByb3BzLmVycm9ySGFuZGxpbmc/LmVycm9yTG9jYXRpb24/LnByZWZpeCxcbiAgICAgICAgICBmYWlsT25GaXJzdEVycm9yOiB0aGlzLnByb3BzLmVycm9ySGFuZGxpbmcuZmFpbE9uRmlyc3RFcnJvcixcbiAgICAgICAgfSxcbiAgICAgICAgaWRGaWVsZE5hbWVzOiB0aGlzLnByb3BzLm9wZXJhdGlvbi5pZHMsXG4gICAgICAgIG9iamVjdDogdGhpcy5wcm9wcy5vYmplY3QsXG4gICAgICAgIHdyaXRlT3BlcmF0aW9uVHlwZTogdGhpcy5wcm9wcy5vcGVyYXRpb24udHlwZSxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxuXG4gIHByaXZhdGUgdHJ5QWRkTm9kZURlcGVuZGVuY3koXG4gICAgc2NvcGU6IElDb25zdHJ1Y3QsXG4gICAgcmVzb3VyY2U/OiBJQ29uc3RydWN0IHwgc3RyaW5nLFxuICApIHtcbiAgICBpZiAocmVzb3VyY2UgJiYgdHlwZW9mIHJlc291cmNlICE9PSBcInN0cmluZ1wiKSB7XG4gICAgICBzY29wZS5ub2RlLmFkZERlcGVuZGVuY3kocmVzb3VyY2UpO1xuICAgIH1cbiAgfVxufVxuIl19