"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesforceMarketingCloudSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
/**
 * A class that represents a Salesforce Marketing Cloud Source
 */
class SalesforceMarketingCloudSource {
    constructor(props) {
        this.props = props;
        /**
         * The AppFlow type of the connector that this source is implemented for
         */
        this.connectorType = type_1.SalesforceMarketingCloudConnectorType.instance;
    }
    bind(scope) {
        this.tryAddNodeDependency(scope, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            apiVersion: this.props.apiVersion,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        return {
            customConnector: {
                entityName: this.props.object,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.SalesforceMarketingCloudSource = SalesforceMarketingCloudSource;
_a = JSII_RTTI_SYMBOL_1;
SalesforceMarketingCloudSource[_a] = { fqn: "@cdklabs/cdk-appflow.SalesforceMarketingCloudSource", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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