"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesforceMarketingCloudConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
class SalesforceMarketingCloudConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, {
            arn,
        });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, {
            name,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.SalesforceMarketingCloudConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                oAuth2Properties: {
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.CLIENT_CREDENTIALS,
                    tokenUrl: properties.oAuth.endpoints.token,
                },
                profileProperties: {
                    instanceUrl: properties.instanceUrl,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    accessToken: properties.oAuth.accessToken?.unsafeUnwrap(),
                    clientId: properties.oAuth.flow?.clientCredentials.clientId?.unsafeUnwrap(),
                    clientSecret: properties.oAuth.flow?.clientCredentials.clientSecret?.unsafeUnwrap(),
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.SalesforceMarketingCloudConnectorProfile = SalesforceMarketingCloudConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
SalesforceMarketingCloudConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.SalesforceMarketingCloudConnectorProfile", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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