"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3ConnectorType = void 0;
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const connector_type_1 = require("../core/connectors/connector-type");
/**
 * @internal
 */
class S3ConnectorType extends connector_type_1.ConnectorType {
    static get instance() {
        if (!S3ConnectorType.actualInstance) {
            S3ConnectorType.actualInstance = new S3ConnectorType();
        }
        return S3ConnectorType.actualInstance;
    }
    constructor() {
        super("S3", false);
    }
}
exports.S3ConnectorType = S3ConnectorType;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9zMy90eXBlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBOzs7RUFHRTtBQUNGLHNFQUFrRTtBQUVsRTs7R0FFRztBQUNILE1BQWEsZUFBZ0IsU0FBUSw4QkFBYTtJQUN6QyxNQUFNLEtBQUssUUFBUTtRQUN4QixJQUFJLENBQUMsZUFBZSxDQUFDLGNBQWMsRUFBRSxDQUFDO1lBQ3BDLGVBQWUsQ0FBQyxjQUFjLEdBQUcsSUFBSSxlQUFlLEVBQUUsQ0FBQztRQUN6RCxDQUFDO1FBQ0QsT0FBTyxlQUFlLENBQUMsY0FBYyxDQUFDO0lBQ3hDLENBQUM7SUFJRDtRQUNFLEtBQUssQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDckIsQ0FBQztDQUNGO0FBYkQsMENBYUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENvbm5lY3RvclR5cGUgfSBmcm9tIFwiLi4vY29yZS9jb25uZWN0b3JzL2Nvbm5lY3Rvci10eXBlXCI7XG5cbi8qKlxuICogQGludGVybmFsXG4gKi9cbmV4cG9ydCBjbGFzcyBTM0Nvbm5lY3RvclR5cGUgZXh0ZW5kcyBDb25uZWN0b3JUeXBlIHtcbiAgcHVibGljIHN0YXRpYyBnZXQgaW5zdGFuY2UoKTogQ29ubmVjdG9yVHlwZSB7XG4gICAgaWYgKCFTM0Nvbm5lY3RvclR5cGUuYWN0dWFsSW5zdGFuY2UpIHtcbiAgICAgIFMzQ29ubmVjdG9yVHlwZS5hY3R1YWxJbnN0YW5jZSA9IG5ldyBTM0Nvbm5lY3RvclR5cGUoKTtcbiAgICB9XG4gICAgcmV0dXJuIFMzQ29ubmVjdG9yVHlwZS5hY3R1YWxJbnN0YW5jZTtcbiAgfVxuXG4gIHByaXZhdGUgc3RhdGljIGFjdHVhbEluc3RhbmNlOiBDb25uZWN0b3JUeXBlO1xuXG4gIGNvbnN0cnVjdG9yKCkge1xuICAgIHN1cGVyKFwiUzNcIiwgZmFsc2UpO1xuICB9XG59XG4iXX0=