"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3Source = exports.S3InputFileType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
/**
 * The file type that Amazon AppFlow gets from your Amazon S3 bucket.
 */
var S3InputFileType;
(function (S3InputFileType) {
    S3InputFileType["CSV"] = "CSV";
    S3InputFileType["JSON"] = "JSON";
})(S3InputFileType || (exports.S3InputFileType = S3InputFileType = {}));
class S3Source {
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.S3ConnectorType.instance;
    }
    bind(scope) {
        this.tryAddNodeDependency(scope, this.props.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketRead(this.props.bucket);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        return {
            s3: {
                bucketName: this.props.bucket.bucketName,
                bucketPrefix: this.props.prefix,
                s3InputFormatConfig: this.props.format && {
                    s3InputFileType: this.props.format.type,
                },
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.S3Source = S3Source;
_a = JSII_RTTI_SYMBOL_1;
S3Source[_a] = { fqn: "@cdklabs/cdk-appflow.S3Source", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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