"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RedshiftDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
class RedshiftDestination {
    constructor(props) {
        this.props = props;
        this.defaultSchema = "public";
        this.connectorType = type_1.RedshiftConnectorType.instance;
    }
    bind(scope) {
        this.tryAddNodeDependency(scope, this.props.errorHandling?.errorLocation?.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        this.tryAddNodeDependency(scope, this.props.profile);
        this.tryAddNodeDependency(scope, this.props.object.table);
        // NOTE: interesting case that the profile requires to have the table created
        //       without it the deployment failed
        this.tryAddNodeDependency(this.props.profile, this.props.object.table);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            redshift: {
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling.failOnFirstError,
                },
                // TODO: identify if this needs to be the same as the bucketName/prefix in the profile
                //       for now that is the assumption and we're pulling this data from the profile
                intermediateBucketName: this.props.profile._location.bucket.bucketName,
                bucketPrefix: this.props.profile._location.prefix,
                object: this.buildObject(this.props.object.table, this.props.object.schema),
            },
        };
    }
    buildObject(table, schema) {
        const _schema = schema ?? this.defaultSchema;
        if (typeof table === "string") {
            return `${_schema}.${table}`;
        }
        return `${_schema}.${table.tableName}`;
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.RedshiftDestination = RedshiftDestination;
_a = JSII_RTTI_SYMBOL_1;
RedshiftDestination[_a] = { fqn: "@cdklabs/cdk-appflow.RedshiftDestination", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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