import { ITable } from "@aws-cdk/aws-redshift-alpha";
import { CfnFlow } from "aws-cdk-lib/aws-appflow";
import { RedshiftConnectorProfile } from "./profile";
import { ErrorHandlingConfiguration, IFlow } from "../core";
import { ConnectorType } from "../core/connectors/connector-type";
import { IDestination } from "../core/vertices";
export interface RedshiftDestinationObject {
    readonly table: string | ITable;
    /**
     * @default public
     */
    readonly schema?: string;
}
export interface RedshiftDestinationProps {
    /**
     * An instance of the @type RedshiftConnectorProfile
     */
    readonly profile: RedshiftConnectorProfile;
    /**
     * A Redshift table object (optionally with the schema).
     */
    readonly object: RedshiftDestinationObject;
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure.
     */
    readonly errorHandling?: ErrorHandlingConfiguration;
}
export declare class RedshiftDestination implements IDestination {
    private readonly props;
    private readonly defaultSchema;
    readonly connectorType: ConnectorType;
    constructor(props: RedshiftDestinationProps);
    bind(scope: IFlow): CfnFlow.DestinationFlowConfigProperty;
    private buildDestinationConnectorProperties;
    private buildObject;
    private tryAddNodeDependency;
}
