"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicrosoftSharepointOnlineApiVersion = exports.MicrosoftSharepointOnlineTokenUrlBuilder = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
/**
 * A utility class for building Microsoft Online token URLs.
 */
class MicrosoftSharepointOnlineTokenUrlBuilder {
    static buildTokenUrl(tenantId) {
        return `https://login.microsoftonline.com/${tenantId ?? "common"}/oauth2/v2.0/token`;
    }
}
exports.MicrosoftSharepointOnlineTokenUrlBuilder = MicrosoftSharepointOnlineTokenUrlBuilder;
_a = JSII_RTTI_SYMBOL_1;
MicrosoftSharepointOnlineTokenUrlBuilder[_a] = { fqn: "@cdklabs/cdk-appflow.MicrosoftSharepointOnlineTokenUrlBuilder", version: "0.2.1" };
/**
 * An enum representing the Microsoft Sharepoint Online API versions.
 */
var MicrosoftSharepointOnlineApiVersion;
(function (MicrosoftSharepointOnlineApiVersion) {
    /**
     * Version 1.0
     */
    MicrosoftSharepointOnlineApiVersion["V1"] = "v1.0";
})(MicrosoftSharepointOnlineApiVersion || (exports.MicrosoftSharepointOnlineApiVersion = MicrosoftSharepointOnlineApiVersion = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9taWNyb3NvZnRzaGFyZXBvaW50b25saW5lL3V0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQTs7O0VBR0U7QUFFRjs7R0FFRztBQUNILE1BQWEsd0NBQXdDO0lBQzVDLE1BQU0sQ0FBQyxhQUFhLENBQUMsUUFBaUI7UUFDM0MsT0FBTyxxQ0FBcUMsUUFBUSxJQUFJLFFBQVEsb0JBQW9CLENBQUM7SUFDdkYsQ0FBQzs7QUFISCw0RkFJQzs7O0FBRUQ7O0dBRUc7QUFDSCxJQUFZLG1DQUtYO0FBTEQsV0FBWSxtQ0FBbUM7SUFDN0M7O09BRUc7SUFDSCxrREFBVyxDQUFBO0FBQ2IsQ0FBQyxFQUxXLG1DQUFtQyxtREFBbkMsbUNBQW1DLFFBSzlDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5cbi8qKlxuICogQSB1dGlsaXR5IGNsYXNzIGZvciBidWlsZGluZyBNaWNyb3NvZnQgT25saW5lIHRva2VuIFVSTHMuXG4gKi9cbmV4cG9ydCBjbGFzcyBNaWNyb3NvZnRTaGFyZXBvaW50T25saW5lVG9rZW5VcmxCdWlsZGVyIHtcbiAgcHVibGljIHN0YXRpYyBidWlsZFRva2VuVXJsKHRlbmFudElkPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIGBodHRwczovL2xvZ2luLm1pY3Jvc29mdG9ubGluZS5jb20vJHt0ZW5hbnRJZCA/PyBcImNvbW1vblwifS9vYXV0aDIvdjIuMC90b2tlbmA7XG4gIH1cbn1cblxuLyoqXG4gKiBBbiBlbnVtIHJlcHJlc2VudGluZyB0aGUgTWljcm9zb2Z0IFNoYXJlcG9pbnQgT25saW5lIEFQSSB2ZXJzaW9ucy5cbiAqL1xuZXhwb3J0IGVudW0gTWljcm9zb2Z0U2hhcmVwb2ludE9ubGluZUFwaVZlcnNpb24ge1xuICAvKipcbiAgICogVmVyc2lvbiAxLjBcbiAgICovXG4gIFYxID0gXCJ2MS4wXCIsXG59XG4iXX0=