"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicrosoftSharepointOnlineSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
const type_1 = require("./type");
/**
 * A class that represents a Microsoft Sharepoint Online Source
 */
class MicrosoftSharepointOnlineSource {
    constructor(props) {
        this.props = props;
        /**
         * The AppFlow type of the connector that this source is implemented for
         */
        this.connectorType = type_1.MicrosoftSharepointOnlineConnectorType.instance;
    }
    bind(scope) {
        this.tryAddNodeDependency(scope, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            apiVersion: this.props.apiVersion,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        if (this.props.object.entities && this.props.object.drives) {
            throw new Error("Only one of the properties entities or drives should be specified");
        }
        const entities = this.props.object.entities ?? this.props.object.drives ?? [];
        if (entities.length < 1) {
            throw new Error("At least one entity must be specified");
        }
        return {
            customConnector: {
                entityName: this.props.object.site,
                customProperties: {
                    subEntities: `["${aws_cdk_lib_1.Fn.join('","', entities)}"]`,
                },
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.MicrosoftSharepointOnlineSource = MicrosoftSharepointOnlineSource;
_a = JSII_RTTI_SYMBOL_1;
MicrosoftSharepointOnlineSource[_a] = { fqn: "@cdklabs/cdk-appflow.MicrosoftSharepointOnlineSource", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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