"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicrosoftSharepointOnlineConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const util_1 = require("./util");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
/**
 * A class that represents a Microsoft Sharepoint Online Connector Profile.
 *
 * This connector profile allows to transfer document libraries residing on a Microsoft Sharepoint Online's site to Amazon S3.
 */
class MicrosoftSharepointOnlineConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, {
            arn,
        });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, {
            name,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.MicrosoftSharepointOnlineConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                oAuth2Properties: {
                    // INFO: even if we're using a refresh token grant flow this property is required
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.AUTHORIZATION_CODE,
                    // INFO: even if we provide only the access token this property is required
                    // TODO: think about if this is correct. token can be IResolvable
                    tokenUrl: properties.oAuth.endpoints?.token ??
                        MicrosoftSharepointOnlineConnectorProfile.defaultTokenEndpoint,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    // INFO: when using Refresh Token Grant Flow - access token property is required
                    accessToken: properties.oAuth.accessToken?.unsafeUnwrap() ?? "dummyAccessToken",
                    // INFO: when passing only an access token - this value is still required
                    refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken?.unsafeUnwrap() ??
                        "dummyRefreshToken",
                    clientId: properties.oAuth.flow?.refreshTokenGrant.clientId?.unsafeUnwrap(),
                    clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret?.unsafeUnwrap(),
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.MicrosoftSharepointOnlineConnectorProfile = MicrosoftSharepointOnlineConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
MicrosoftSharepointOnlineConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.MicrosoftSharepointOnlineConnectorProfile", version: "0.2.1" };
MicrosoftSharepointOnlineConnectorProfile.defaultTokenEndpoint = util_1.MicrosoftSharepointOnlineTokenUrlBuilder.buildTokenUrl();
//# sourceMappingURL=data:application/json;base64,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