"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicrosoftDynamics365ApiVersion = exports.MicrosoftDynamics365ApiUrlBuilder = exports.MicrosoftDynamics365TokenUrlBuilder = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
/**
 * A utility class for building Microsoft Dynamics 365 token URLs.
 */
class MicrosoftDynamics365TokenUrlBuilder {
    static buildTokenUrl(tenantId) {
        return `https://login.microsoftonline.com/${tenantId ?? "common"}/oauth2/v2.0/token`;
    }
}
exports.MicrosoftDynamics365TokenUrlBuilder = MicrosoftDynamics365TokenUrlBuilder;
_a = JSII_RTTI_SYMBOL_1;
MicrosoftDynamics365TokenUrlBuilder[_a] = { fqn: "@cdklabs/cdk-appflow.MicrosoftDynamics365TokenUrlBuilder", version: "0.2.1" };
class MicrosoftDynamics365ApiUrlBuilder {
    static buildApiUrl(org) {
        return `https://${org}.api.crm.dynamics.com`;
    }
}
exports.MicrosoftDynamics365ApiUrlBuilder = MicrosoftDynamics365ApiUrlBuilder;
_b = JSII_RTTI_SYMBOL_1;
MicrosoftDynamics365ApiUrlBuilder[_b] = { fqn: "@cdklabs/cdk-appflow.MicrosoftDynamics365ApiUrlBuilder", version: "0.2.1" };
/**
 * An enum representing the Microsoft Dynamics 365 API versions.
 */
var MicrosoftDynamics365ApiVersion;
(function (MicrosoftDynamics365ApiVersion) {
    /**
     * Version 9.2
     */
    MicrosoftDynamics365ApiVersion["V9_2"] = "v9.2";
})(MicrosoftDynamics365ApiVersion || (exports.MicrosoftDynamics365ApiVersion = MicrosoftDynamics365ApiVersion = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9taWNyb3NvZnRkeW5hbWljczM2NS91dGlsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUE7OztFQUdFO0FBRUY7O0dBRUc7QUFDSCxNQUFhLG1DQUFtQztJQUN2QyxNQUFNLENBQUMsYUFBYSxDQUFDLFFBQWlCO1FBQzNDLE9BQU8scUNBQXFDLFFBQVEsSUFBSSxRQUFRLG9CQUFvQixDQUFDO0lBQ3ZGLENBQUM7O0FBSEgsa0ZBSUM7OztBQUVELE1BQWEsaUNBQWlDO0lBQ3JDLE1BQU0sQ0FBQyxXQUFXLENBQUMsR0FBVztRQUNuQyxPQUFPLFdBQVcsR0FBRyx1QkFBdUIsQ0FBQztJQUMvQyxDQUFDOztBQUhILDhFQUlDOzs7QUFFRDs7R0FFRztBQUNILElBQVksOEJBS1g7QUFMRCxXQUFZLDhCQUE4QjtJQUN4Qzs7T0FFRztJQUNILCtDQUFhLENBQUE7QUFDZixDQUFDLEVBTFcsOEJBQThCLDhDQUE5Qiw4QkFBOEIsUUFLekMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cblxuLyoqXG4gKiBBIHV0aWxpdHkgY2xhc3MgZm9yIGJ1aWxkaW5nIE1pY3Jvc29mdCBEeW5hbWljcyAzNjUgdG9rZW4gVVJMcy5cbiAqL1xuZXhwb3J0IGNsYXNzIE1pY3Jvc29mdER5bmFtaWNzMzY1VG9rZW5VcmxCdWlsZGVyIHtcbiAgcHVibGljIHN0YXRpYyBidWlsZFRva2VuVXJsKHRlbmFudElkPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIGBodHRwczovL2xvZ2luLm1pY3Jvc29mdG9ubGluZS5jb20vJHt0ZW5hbnRJZCA/PyBcImNvbW1vblwifS9vYXV0aDIvdjIuMC90b2tlbmA7XG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIE1pY3Jvc29mdER5bmFtaWNzMzY1QXBpVXJsQnVpbGRlciB7XG4gIHB1YmxpYyBzdGF0aWMgYnVpbGRBcGlVcmwob3JnOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gYGh0dHBzOi8vJHtvcmd9LmFwaS5jcm0uZHluYW1pY3MuY29tYDtcbiAgfVxufVxuXG4vKipcbiAqIEFuIGVudW0gcmVwcmVzZW50aW5nIHRoZSBNaWNyb3NvZnQgRHluYW1pY3MgMzY1IEFQSSB2ZXJzaW9ucy5cbiAqL1xuZXhwb3J0IGVudW0gTWljcm9zb2Z0RHluYW1pY3MzNjVBcGlWZXJzaW9uIHtcbiAgLyoqXG4gICAqIFZlcnNpb24gOS4yXG4gICAqL1xuICBWOV8yID0gXCJ2OS4yXCIsXG59XG4iXX0=