import { CfnFlow } from "aws-cdk-lib/aws-appflow";
import { MicrosoftDynamics365ConnectorProfile } from "./profile";
import { ConnectorType } from "../core/connectors/connector-type";
import { IFlow } from "../core/flows";
import { ISource } from "../core/vertices";
/**
 * Properties of a Microsoft Dynamics 365 Source
 */
export interface MicrosoftDynamics365SourceProps {
    readonly profile: MicrosoftDynamics365ConnectorProfile;
    readonly apiVersion: string;
    readonly object: string;
}
/**
 * A class that represents a Microsoft Dynamics 365 Source
 */
export declare class MicrosoftDynamics365Source implements ISource {
    private readonly props;
    /**
     * The AppFlow type of the connector that this source is implemented for
     */
    readonly connectorType: ConnectorType;
    constructor(props: MicrosoftDynamics365SourceProps);
    bind(scope: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
