"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicrosoftDynamics365ConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const util_1 = require("./util");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
/**
 * A class that represents a Microsoft Dynamics 365 Connector Profile.
 *
 * This connector profile allows to transfer document libraries residing on a Microsoft Dynamics 365's site to Amazon S3.
 */
class MicrosoftDynamics365ConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, {
            arn,
        });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, {
            name,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.MicrosoftDynamics365ConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                profileProperties: {
                    instanceUrl: properties.instanceUrl,
                },
                oAuth2Properties: {
                    // INFO: even if we're using a refresh token grant flow this property is required
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.AUTHORIZATION_CODE,
                    // INFO: even if we provide only the access token this property is required
                    // TODO: think about if this is correct. token can be IResolvable
                    tokenUrl: properties.oAuth.endpoints?.token ??
                        MicrosoftDynamics365ConnectorProfile.defaultTokenEndpoint,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    // INFO: when using Refresh Token Grant Flow - access token property is required
                    accessToken: properties.oAuth.accessToken?.unsafeUnwrap() ?? "dummyAccessToken",
                    // INFO: when passing only an access token - this value is still required
                    refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken?.unsafeUnwrap() ??
                        "dummyRefreshToken",
                    clientId: properties.oAuth.flow?.refreshTokenGrant.clientId?.unsafeUnwrap(),
                    clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret?.unsafeUnwrap(),
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.MicrosoftDynamics365ConnectorProfile = MicrosoftDynamics365ConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
MicrosoftDynamics365ConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.MicrosoftDynamics365ConnectorProfile", version: "0.2.1" };
MicrosoftDynamics365ConnectorProfile.defaultTokenEndpoint = util_1.MicrosoftDynamics365TokenUrlBuilder.buildTokenUrl();
//# sourceMappingURL=data:application/json;base64,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