import { CfnFlow } from "aws-cdk-lib/aws-appflow";
import { MarketoConnectorProfile } from "./profile";
import { ConnectorType } from "../core/connectors/connector-type";
import { IFlow } from "../core/flows";
import { ISource } from "../core/vertices/source";
export interface MarketoSourceProps {
    readonly profile: MarketoConnectorProfile;
    readonly object: string;
    readonly apiVersion?: string;
}
export declare class MarketoSource implements ISource {
    private readonly props;
    readonly connectorType: ConnectorType;
    constructor(props: MarketoSourceProps);
    bind(flow: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
