"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MarketoConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_profile_1 = require("../core/connectors/connector-profile");
class MarketoConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, {
            arn,
        });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, {
            name,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.MarketoConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            marketo: {
                instanceUrl: properties.instanceUrl,
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            marketo: {
                accessToken: properties.oAuth.accessToken?.unsafeUnwrap(),
                clientId: properties.oAuth.flow.clientCredentials.clientId.unsafeUnwrap(),
                clientSecret: properties.oAuth.flow.clientCredentials.clientSecret.unsafeUnwrap(),
            },
        };
    }
}
exports.MarketoConnectorProfile = MarketoConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
MarketoConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.MarketoConnectorProfile", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJvZmlsZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9tYXJrZXRvL3Byb2ZpbGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFPQSxpQ0FBOEM7QUFDOUMsNEVBRzhDO0FBcUI5QyxNQUFhLHVCQUF3QixTQUFRLHdDQUFvQjtJQUN4RCxNQUFNLENBQUMsd0JBQXdCLENBQ3BDLEtBQWdCLEVBQ2hCLEVBQVUsRUFDVixHQUFXO1FBRVgsT0FBTyxJQUFJLENBQUMsK0JBQStCLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNyRCxHQUFHO1NBQ0osQ0FBNEIsQ0FBQztJQUNoQyxDQUFDO0lBRU0sTUFBTSxDQUFDLHlCQUF5QixDQUNyQyxLQUFnQixFQUNoQixFQUFVLEVBQ1YsSUFBWTtRQUVaLE9BQU8sSUFBSSxDQUFDLCtCQUErQixDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDckQsSUFBSTtTQUNMLENBQTRCLENBQUM7SUFDaEMsQ0FBQztJQUVELFlBQ0UsS0FBZ0IsRUFDaEIsRUFBVSxFQUNWLEtBQW1DO1FBRW5DLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssRUFBRSwyQkFBb0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUN6RCxDQUFDO0lBRVMsK0JBQStCLENBQ3ZDLEtBQTRCO1FBRTVCLE1BQU0sVUFBVSxHQUFHLEtBQXFDLENBQUM7UUFDekQsT0FBTztZQUNMLE9BQU8sRUFBRTtnQkFDUCxXQUFXLEVBQUUsVUFBVSxDQUFDLFdBQVc7YUFDcEM7U0FDRixDQUFDO0lBQ0osQ0FBQztJQUVTLGdDQUFnQyxDQUN4QyxLQUE0QjtRQUU1QixNQUFNLFVBQVUsR0FBRyxLQUFxQyxDQUFDO1FBQ3pELE9BQU87WUFDTCxPQUFPLEVBQUU7Z0JBQ1AsV0FBVyxFQUFFLFVBQVUsQ0FBQyxLQUFLLENBQUMsV0FBVyxFQUFFLFlBQVksRUFBRTtnQkFDekQsUUFBUSxFQUNOLFVBQVUsQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLFFBQVEsQ0FBQyxZQUFZLEVBQUU7Z0JBQ2pFLFlBQVksRUFDVixVQUFVLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLENBQUMsWUFBWSxFQUFFO2FBQ3RFO1NBQ0YsQ0FBQztJQUNKLENBQUM7O0FBckRILDBEQXNEQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgU2VjcmV0VmFsdWUgfSBmcm9tIFwiYXdzLWNkay1saWJcIjtcbmltcG9ydCB7IENmbkNvbm5lY3RvclByb2ZpbGUgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWFwcGZsb3dcIjtcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyBNYXJrZXRvQ29ubmVjdG9yVHlwZSB9IGZyb20gXCIuL3R5cGVcIjtcbmltcG9ydCB7XG4gIENvbm5lY3RvclByb2ZpbGVCYXNlLFxuICBDb25uZWN0b3JQcm9maWxlUHJvcHMsXG59IGZyb20gXCIuLi9jb3JlL2Nvbm5lY3RvcnMvY29ubmVjdG9yLXByb2ZpbGVcIjtcblxuZXhwb3J0IGludGVyZmFjZSBNYXJrZXRvQ29ubmVjdG9yUHJvZmlsZVByb3BzIGV4dGVuZHMgQ29ubmVjdG9yUHJvZmlsZVByb3BzIHtcbiAgcmVhZG9ubHkgb0F1dGg6IE1hcmtldG9PQXV0aFNldHRpbmdzO1xuICByZWFkb25seSBpbnN0YW5jZVVybDogc3RyaW5nO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIE1hcmtldG9PQXV0aENsaWVudENyZWRlbnRpYWxzRmxvdyB7XG4gIHJlYWRvbmx5IGNsaWVudElkOiBTZWNyZXRWYWx1ZTtcbiAgcmVhZG9ubHkgY2xpZW50U2VjcmV0OiBTZWNyZXRWYWx1ZTtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBNYXJrZXRvT0F1dGhGbG93IHtcbiAgcmVhZG9ubHkgY2xpZW50Q3JlZGVudGlhbHM6IE1hcmtldG9PQXV0aENsaWVudENyZWRlbnRpYWxzRmxvdztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBNYXJrZXRvT0F1dGhTZXR0aW5ncyB7XG4gIHJlYWRvbmx5IGFjY2Vzc1Rva2VuPzogU2VjcmV0VmFsdWU7XG4gIHJlYWRvbmx5IGZsb3c6IE1hcmtldG9PQXV0aEZsb3c7XG59XG5cbmV4cG9ydCBjbGFzcyBNYXJrZXRvQ29ubmVjdG9yUHJvZmlsZSBleHRlbmRzIENvbm5lY3RvclByb2ZpbGVCYXNlIHtcbiAgcHVibGljIHN0YXRpYyBmcm9tQ29ubmVjdGlvblByb2ZpbGVBcm4oXG4gICAgc2NvcGU6IENvbnN0cnVjdCxcbiAgICBpZDogc3RyaW5nLFxuICAgIGFybjogc3RyaW5nLFxuICApIHtcbiAgICByZXR1cm4gdGhpcy5fZnJvbUNvbm5lY3RvclByb2ZpbGVBdHRyaWJ1dGVzKHNjb3BlLCBpZCwge1xuICAgICAgYXJuLFxuICAgIH0pIGFzIE1hcmtldG9Db25uZWN0b3JQcm9maWxlO1xuICB9XG5cbiAgcHVibGljIHN0YXRpYyBmcm9tQ29ubmVjdGlvblByb2ZpbGVOYW1lKFxuICAgIHNjb3BlOiBDb25zdHJ1Y3QsXG4gICAgaWQ6IHN0cmluZyxcbiAgICBuYW1lOiBzdHJpbmcsXG4gICkge1xuICAgIHJldHVybiB0aGlzLl9mcm9tQ29ubmVjdG9yUHJvZmlsZUF0dHJpYnV0ZXMoc2NvcGUsIGlkLCB7XG4gICAgICBuYW1lLFxuICAgIH0pIGFzIE1hcmtldG9Db25uZWN0b3JQcm9maWxlO1xuICB9XG5cbiAgY29uc3RydWN0b3IoXG4gICAgc2NvcGU6IENvbnN0cnVjdCxcbiAgICBpZDogc3RyaW5nLFxuICAgIHByb3BzOiBNYXJrZXRvQ29ubmVjdG9yUHJvZmlsZVByb3BzLFxuICApIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzLCBNYXJrZXRvQ29ubmVjdG9yVHlwZS5pbnN0YW5jZSk7XG4gIH1cblxuICBwcm90ZWN0ZWQgYnVpbGRDb25uZWN0b3JQcm9maWxlUHJvcGVydGllcyhcbiAgICBwcm9wczogQ29ubmVjdG9yUHJvZmlsZVByb3BzLFxuICApOiBDZm5Db25uZWN0b3JQcm9maWxlLkNvbm5lY3RvclByb2ZpbGVQcm9wZXJ0aWVzUHJvcGVydHkge1xuICAgIGNvbnN0IHByb3BlcnRpZXMgPSBwcm9wcyBhcyBNYXJrZXRvQ29ubmVjdG9yUHJvZmlsZVByb3BzO1xuICAgIHJldHVybiB7XG4gICAgICBtYXJrZXRvOiB7XG4gICAgICAgIGluc3RhbmNlVXJsOiBwcm9wZXJ0aWVzLmluc3RhbmNlVXJsLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG5cbiAgcHJvdGVjdGVkIGJ1aWxkQ29ubmVjdG9yUHJvZmlsZUNyZWRlbnRpYWxzKFxuICAgIHByb3BzOiBDb25uZWN0b3JQcm9maWxlUHJvcHMsXG4gICk6IENmbkNvbm5lY3RvclByb2ZpbGUuQ29ubmVjdG9yUHJvZmlsZUNyZWRlbnRpYWxzUHJvcGVydHkge1xuICAgIGNvbnN0IHByb3BlcnRpZXMgPSBwcm9wcyBhcyBNYXJrZXRvQ29ubmVjdG9yUHJvZmlsZVByb3BzO1xuICAgIHJldHVybiB7XG4gICAgICBtYXJrZXRvOiB7XG4gICAgICAgIGFjY2Vzc1Rva2VuOiBwcm9wZXJ0aWVzLm9BdXRoLmFjY2Vzc1Rva2VuPy51bnNhZmVVbndyYXAoKSxcbiAgICAgICAgY2xpZW50SWQ6XG4gICAgICAgICAgcHJvcGVydGllcy5vQXV0aC5mbG93LmNsaWVudENyZWRlbnRpYWxzLmNsaWVudElkLnVuc2FmZVVud3JhcCgpLFxuICAgICAgICBjbGllbnRTZWNyZXQ6XG4gICAgICAgICAgcHJvcGVydGllcy5vQXV0aC5mbG93LmNsaWVudENyZWRlbnRpYWxzLmNsaWVudFNlY3JldC51bnNhZmVVbndyYXAoKSxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxufVxuIl19