import { SecretValue } from "aws-cdk-lib";
import { CfnConnectorProfile } from "aws-cdk-lib/aws-appflow";
import { Construct } from "constructs";
import { ConnectorProfileBase, ConnectorProfileProps } from "../core/connectors/connector-profile";
export interface MarketoConnectorProfileProps extends ConnectorProfileProps {
    readonly oAuth: MarketoOAuthSettings;
    readonly instanceUrl: string;
}
export interface MarketoOAuthClientCredentialsFlow {
    readonly clientId: SecretValue;
    readonly clientSecret: SecretValue;
}
export interface MarketoOAuthFlow {
    readonly clientCredentials: MarketoOAuthClientCredentialsFlow;
}
export interface MarketoOAuthSettings {
    readonly accessToken?: SecretValue;
    readonly flow: MarketoOAuthFlow;
}
export declare class MarketoConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): MarketoConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): MarketoConnectorProfile;
    constructor(scope: Construct, id: string, props: MarketoConnectorProfileProps);
    protected buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
}
