"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MarketoDestination = void 0;
const type_1 = require("./type");
const core_1 = require("../core");
class MarketoDestination {
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.MarketoConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.errorHandling?.errorLocation?.bucket);
        this.tryAddNodeDependency(flow, this.props.profile);
        core_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            marketo: {
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket?.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling.failOnFirstError,
                },
                object: this.props.object,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource) {
            scope.node.addDependency(resource);
        }
    }
}
exports.MarketoDestination = MarketoDestination;
//# sourceMappingURL=data:application/json;base64,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