"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MailchimpSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
/**
 * A class that represents a Mailchimp v3 Source
 */
class MailchimpSource {
    constructor(props) {
        this.props = props;
        /**
         * The AppFlow type of the connector that this source is implemented for
         */
        this.connectorType = type_1.MailchimpConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            apiVersion: this.props.apiVersion,
            connectorProfileName: this.props.profile.name,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        return {
            customConnector: {
                entityName: this.props.object,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.MailchimpSource = MailchimpSource;
_a = JSII_RTTI_SYMBOL_1;
MailchimpSource[_a] = { fqn: "@cdklabs/cdk-appflow.MailchimpSource", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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