"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MailchimpConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
/**
 * A class that represents a Mailchimp Connector Profile.
 *
 */
class MailchimpConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, {
            arn,
        });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, {
            name,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.MailchimpConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                profileProperties: {
                    instanceUrl: properties.instanceUrl,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.CUSTOM,
                custom: {
                    credentialsMap: {
                        api_key: properties.apiKey.unsafeUnwrap(),
                    },
                    customAuthenticationType: "api_key",
                },
            },
        };
    }
}
exports.MailchimpConnectorProfile = MailchimpConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
MailchimpConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.MailchimpConnectorProfile", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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