import { SecretValue } from "aws-cdk-lib";
import { CfnConnectorProfile } from "aws-cdk-lib/aws-appflow";
import { Construct } from "constructs";
import { ConnectorProfileBase, ConnectorProfileProps } from "../core/connectors/connector-profile";
export interface MailchimpConnectorProfileProps extends ConnectorProfileProps {
    readonly apiKey: SecretValue;
    readonly instanceUrl: string;
}
/**
 * A class that represents a Mailchimp Connector Profile.
 *
 */
export declare class MailchimpConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): MailchimpConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): MailchimpConnectorProfile;
    constructor(scope: Construct, id: string, props: MailchimpConnectorProfileProps);
    protected buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
}
