"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JdbcSmallDataScaleSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
class JdbcSmallDataScaleSource {
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.JdbcSmallDataScaleConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            apiVersion: this.props.apiVersion ?? JdbcSmallDataScaleSource.defaultApiVersion,
            connectorProfileName: this.props.profile.name,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        return {
            customConnector: {
                entityName: `${this.props.object.schema}.${this.props.object.table}`,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.JdbcSmallDataScaleSource = JdbcSmallDataScaleSource;
_a = JSII_RTTI_SYMBOL_1;
JdbcSmallDataScaleSource[_a] = { fqn: "@cdklabs/cdk-appflow.JdbcSmallDataScaleSource", version: "0.2.1" };
JdbcSmallDataScaleSource.defaultApiVersion = "V1";
//# sourceMappingURL=data:application/json;base64,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