import { CfnFlow } from "aws-cdk-lib/aws-appflow";
import { JdbcSmallDataScaleConnectorProfile } from "./profile";
import { ConnectorType } from "../core/connectors/connector-type";
import { IFlow } from "../core/flows";
import { ISource } from "../core/vertices/source";
export interface JdbcSmallDataScaleObject {
    readonly schema: string;
    readonly table: string;
}
export interface JdbcSmallDataScaleSourceProps {
    readonly profile: JdbcSmallDataScaleConnectorProfile;
    readonly object: JdbcSmallDataScaleObject;
    readonly apiVersion?: string;
}
export declare class JdbcSmallDataScaleSource implements ISource {
    private readonly props;
    private static readonly defaultApiVersion;
    readonly connectorType: ConnectorType;
    constructor(props: JdbcSmallDataScaleSourceProps);
    bind(flow: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
