"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JdbcSmallDataScaleConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const core_1 = require("../core");
const connector_profile_1 = require("../core/connectors/connector-profile");
/**
 * The connector profile for the JDBC connector
 */
class JdbcSmallDataScaleConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    /**
     * Imports an existing JdbcSmallDataScaleConnectorProfile
     * @param scope the scope for the connector profile
     * @param id the connector profile's ID
     * @param arn the ARN for the existing connector profile
     * @returns An instance of the JdbcSmallDataScaleConnectorProfile
     */
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, {
            arn,
        });
    }
    /**
     * Imports an existing JdbcSmallDataScaleConnectorProfile
     * @param scope the scope for the connector profile
     * @param id the connector profile's ID
     * @param name the name for the existing connector profile
     * @returns An instance of the JdbcSmallDataScaleConnectorProfile
     */
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, {
            name,
        });
    }
    /**
     * Creates a new instance of the JdbcSmallDataScaleConnectorProfile
     * @param scope the Construct scope for this connector profile
     * @param id the id of this connector profile
     * @param props properties to use when instantiating this connector profile
     */
    constructor(scope, id, props) {
        super(scope, id, props, type_1.JdbcSmallDataScaleConnectorType.instance);
    }
    buildConnectorProfileProperties(_props) {
        return {
            customConnector: {
                profileProperties: {},
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                authenticationType: core_1.ConnectorAuthenticationType.CUSTOM,
                custom: {
                    credentialsMap: {
                        username: properties.basicAuth.username,
                        password: properties.basicAuth.password.unsafeUnwrap(),
                        driver: properties.driver,
                        hostname: properties.hostname,
                        port: `${properties.port}`,
                        database: properties.database,
                    },
                    customAuthenticationType: "CUSTOM",
                },
            },
        };
    }
}
exports.JdbcSmallDataScaleConnectorProfile = JdbcSmallDataScaleConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
JdbcSmallDataScaleConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.JdbcSmallDataScaleConnectorProfile", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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