"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JdbcSmallDataScaleDestination = void 0;
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
const write_operation_1 = require("../core/write-operation");
/**
 * Represents a destination for the JDBC connector
 */
class JdbcSmallDataScaleDestination {
    /**
     * Creates a new instance of the JdbcSmallDataScaleDestination
     * @param props - properties of the destination
     */
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.JdbcSmallDataScaleConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.errorHandling?.errorLocation?.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        this.tryAddNodeDependency(flow, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            apiVersion: this.props.apiVersion ??
                JdbcSmallDataScaleDestination.defaultApiVersion,
            connectorProfileName: this.props.profile.name,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            customConnector: {
                entityName: `${this.props.object.schema}.${this.props.object.table}`,
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling.failOnFirstError,
                },
                writeOperationType: write_operation_1.WriteOperationType.INSERT,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.JdbcSmallDataScaleDestination = JdbcSmallDataScaleDestination;
JdbcSmallDataScaleDestination.defaultApiVersion = "V1";
//# sourceMappingURL=data:application/json;base64,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