import { CfnFlow } from "aws-cdk-lib/aws-appflow";
import { JdbcSmallDataScaleConnectorProfile } from "./profile";
import { ConnectorType } from "../core/connectors/connector-type";
import { ErrorHandlingConfiguration } from "../core/error-handling";
import { IFlow } from "../core/flows";
import { IDestination } from "../core/vertices/destination";
/**
 * The definition of the Amazon AppFlow object for JdbcSmallDestination
 */
export interface JdbcSmallDataScaleObject {
    /**
     * Database schema name of the table
     */
    readonly schema: string;
    /**
     * Database table name
     */
    readonly table: string;
}
/**
 * Properties of the JdbcSmallDataScaleDestination
 */
export interface JdbcSmallDataScaleDestinationProps {
    /**
     * The profile to use with the destination
     */
    readonly profile: JdbcSmallDataScaleConnectorProfile;
    /**
     * The Amazon AppFlow Api Version
     */
    readonly apiVersion?: string;
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure.
     */
    readonly errorHandling?: ErrorHandlingConfiguration;
    /**
     * The destination object table to write to
     */
    readonly object: JdbcSmallDataScaleObject;
}
/**
 * Represents a destination for the JDBC connector
 */
export declare class JdbcSmallDataScaleDestination implements IDestination {
    private readonly props;
    private static readonly defaultApiVersion;
    readonly connectorType: ConnectorType;
    /**
     * Creates a new instance of the JdbcSmallDataScaleDestination
     * @param props - properties of the destination
     */
    constructor(props: JdbcSmallDataScaleDestinationProps);
    bind(flow: IFlow): CfnFlow.DestinationFlowConfigProperty;
    private buildDestinationConnectorProperties;
    private tryAddNodeDependency;
}
