import { CfnFlow } from "aws-cdk-lib/aws-appflow";
import { HubSpotConnectorProfile } from "./profile";
import { HubSpotApiVersion } from "./util";
import { ConnectorType } from "../core/connectors/connector-type";
import { IFlow } from "../core/flows";
import { ISource } from "../core/vertices";
/**
 * Properties of a Hubspot Source
 */
export interface HubSpotSourceProps {
    readonly profile: HubSpotConnectorProfile;
    readonly apiVersion: HubSpotApiVersion;
    readonly entity: string[];
}
/**
 * A class that represents a Hubspot Source
 */
export declare class HubSpotSource implements ISource {
    private readonly props;
    /**
     * The AppFlow type of the connector that this source is implemented for
     */
    readonly connectorType: ConnectorType;
    constructor(props: HubSpotSourceProps);
    bind(scope: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
