"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HubSpotConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
class HubSpotConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, {
            arn,
        });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, {
            name,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.HubSpotConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                oAuth2Properties: {
                    // INFO: even if we're using a refresh token grant flow this property is required
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.AUTHORIZATION_CODE,
                    // INFO: even if we provide only the access token this property is required
                    // TODO: think about if this is correct. token can be IResolvable
                    tokenUrl: properties.oAuth.endpoints?.token ??
                        HubSpotConnectorProfile.defaultTokenEndpoint,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    // INFO: when using Refresh Token Grant Flow - access token property is required
                    accessToken: properties.oAuth.accessToken?.unsafeUnwrap() ?? "dummyAccessToken",
                    refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken?.unsafeUnwrap(),
                    clientId: properties.oAuth.flow?.refreshTokenGrant.clientId?.unsafeUnwrap(),
                    clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret?.unsafeUnwrap(),
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.HubSpotConnectorProfile = HubSpotConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
HubSpotConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.HubSpotConnectorProfile", version: "0.2.1" };
HubSpotConnectorProfile.defaultTokenEndpoint = "https://api.hubapi.com/oauth/v1/token";
//# sourceMappingURL=data:application/json;base64,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