import { SecretValue } from "aws-cdk-lib";
import { CfnConnectorProfile } from "aws-cdk-lib/aws-appflow";
import { Construct } from "constructs";
import { ConnectorProfileBase, ConnectorProfileProps } from "../core/connectors/connector-profile";
export interface HubSpotConnectorProfileProps extends ConnectorProfileProps {
    readonly oAuth: HubSpotOAuthSettings;
}
/**
 * Hubspot OAuth token and authorization endpoints
 */
export interface HubSpotOAuthEndpoints {
    /**
     * The OAuth token endpoint URI
     */
    readonly token?: string;
}
/**
 * The OAuth elements required for the execution of the refresh token grant flow.
 */
export interface HubSpotRefreshTokenGrantFlow {
    /**
     * A non-expired refresh token.
     */
    readonly refreshToken?: SecretValue;
    /**
     * The secret of the client app.
     */
    readonly clientSecret?: SecretValue;
    /**
     * The id of the client app.
     */
    readonly clientId?: SecretValue;
}
/**
 * Represents the OAuth flow enabled for the GA4
 */
export interface HubSpotOAuthFlow {
    /**
     * The details required for executing the refresh token grant flow
     */
    readonly refreshTokenGrant: HubSpotRefreshTokenGrantFlow;
}
export interface HubSpotOAuthSettings {
    /**
     * The access token to be used when interacting with Hubspot
     *
     * Note that if only the access token is provided AppFlow is not able to retrieve a fresh access token when the current one is expired
     *
     * @default Retrieves a fresh accessToken with the information in the [flow property]{@link HubSpotOAuthSettings#flow}
     */
    readonly accessToken?: SecretValue;
    /**
     * The OAuth flow used for obtaining a new accessToken when the old is not present or expired.
     *
     * @default undefined. AppFlow will not request any new accessToken after expiry.
     */
    readonly flow?: HubSpotOAuthFlow;
    /**
     * The OAuth token and authorization endpoints.
     */
    readonly endpoints?: HubSpotOAuthEndpoints;
}
export declare class HubSpotConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): HubSpotConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): HubSpotConnectorProfile;
    private static readonly defaultTokenEndpoint;
    constructor(scope: Construct, id: string, props: HubSpotConnectorProfileProps);
    protected buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
}
