import { CfnFlow } from "aws-cdk-lib/aws-appflow";
import { HubSpotConnectorProfile } from "./profile";
import { HubSpotApiVersion } from "./util";
import { ConnectorType } from "../core/connectors/connector-type";
import { ErrorHandlingConfiguration } from "../core/error-handling";
import { IFlow } from "../core/flows";
import { IDestination } from "../core/vertices/destination";
import { WriteOperation } from "../core/write-operation";
export interface HubSpotDestinationProps {
    readonly profile: HubSpotConnectorProfile;
    readonly apiVersion: HubSpotApiVersion;
    readonly entity: string[];
    readonly operation: WriteOperation;
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the HubSpot destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure.
     */
    readonly errorHandling?: ErrorHandlingConfiguration;
}
export declare class HubSpotDestination implements IDestination {
    private readonly props;
    readonly connectorType: ConnectorType;
    constructor(props: HubSpotDestinationProps);
    bind(flow: IFlow): CfnFlow.DestinationFlowConfigProperty;
    private buildDestinationConnectorProperties;
    private tryAddNodeDependency;
}
