import { CfnFlow } from "aws-cdk-lib/aws-appflow";
import { GoogleBigQueryConnectorProfile } from "./profile";
import { ConnectorType } from "../core/connectors/connector-type";
import { IFlow } from "../core/flows";
import { ISource } from "../core/vertices";
export interface GoogleBigQueryObject {
    readonly project: string;
    readonly dataset: string;
    readonly table: string;
}
/**
 * Properties of a Google BigQuery Source
 */
export interface GoogleBigQuerySourceProps {
    readonly profile: GoogleBigQueryConnectorProfile;
    readonly apiVersion: string;
    readonly object: GoogleBigQueryObject;
}
/**
 * A class that represents a Google BigQuery Source
 */
export declare class GoogleBigQuerySource implements ISource {
    private readonly props;
    /**
     * The AppFlow type of the connector that this source is implemented for
     */
    readonly connectorType: ConnectorType;
    constructor(props: GoogleBigQuerySourceProps);
    bind(scope: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
