"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleBigQueryConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
class GoogleBigQueryConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, {
            arn,
        });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, {
            name,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.GoogleBigQueryConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                oAuth2Properties: {
                    // INFO: even if we're using a refresh token grant flow this property is required
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.AUTHORIZATION_CODE,
                    // INFO: even if we provide only the access token this property is required
                    // TODO: think about if this is correct. token can be IResolvable
                    tokenUrl: properties.oAuth.endpoints?.token ??
                        GoogleBigQueryConnectorProfile.defaultTokenEndpoint,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    // INFO: when using Refresh Token Grant Flow - access token property is required
                    accessToken: properties.oAuth.accessToken?.unsafeUnwrap() ?? "dummyAccessToken",
                    refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken?.unsafeUnwrap(),
                    clientId: properties.oAuth.flow?.refreshTokenGrant.clientId?.unsafeUnwrap(),
                    clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret?.unsafeUnwrap(),
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.GoogleBigQueryConnectorProfile = GoogleBigQueryConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
GoogleBigQueryConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.GoogleBigQueryConnectorProfile", version: "0.2.1" };
GoogleBigQueryConnectorProfile.defaultTokenEndpoint = "https://oauth2.googleapis.com/token";
//# sourceMappingURL=data:application/json;base64,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