import { SecretValue } from "aws-cdk-lib";
import { CfnConnectorProfile } from "aws-cdk-lib/aws-appflow";
import { Construct } from "constructs";
import { ConnectorProfileBase, ConnectorProfileProps } from "../core/connectors/connector-profile";
export interface GoogleBigQueryConnectorProfileProps extends ConnectorProfileProps {
    readonly oAuth: GoogleBigQueryOAuthSettings;
}
/**
 * Google's OAuth token and authorization endpoints
 */
export interface GoogleBigQueryOAuthEndpoints {
    /**
     * The OAuth token endpoint URI
     */
    readonly token?: string;
    /**
     * The OAuth authorization endpoint URI
     */
    readonly authorization?: string;
}
/**
 * The OAuth elements required for the execution of the refresh token grant flow.
 */
export interface GoogleBigQueryRefreshTokenGrantFlow {
    /**
     * A non-expired refresh token.
     */
    readonly refreshToken?: SecretValue;
    /**
     * The secret of the client app.
     */
    readonly clientSecret?: SecretValue;
    /**
     * The id of the client app.
     */
    readonly clientId?: SecretValue;
}
/**
 * Represents the OAuth flow enabled for the GA4
 */
export interface GoogleBigQueryOAuthFlow {
    /**
     * The details required for executing the refresh token grant flow
     */
    readonly refreshTokenGrant: GoogleBigQueryRefreshTokenGrantFlow;
}
export interface GoogleBigQueryOAuthSettings {
    /**
     * The access token to be used when interacting with Google BigQuery
     *
     * Note that if only the access token is provided AppFlow is not able to retrieve a fresh access token when the current one is expired
     *
     * @default Retrieves a fresh accessToken with the information in the [flow property]{@link GoogleBigQueryOAuthSettings#flow}
     */
    readonly accessToken?: SecretValue;
    /**
     * The OAuth flow used for obtaining a new accessToken when the old is not present or expired.
     *
     * @default undefined. AppFlow will not request any new accessToken after expiry.
     */
    readonly flow?: GoogleBigQueryOAuthFlow;
    /**
     * The OAuth token and authorization endpoints.
     */
    readonly endpoints?: GoogleBigQueryOAuthEndpoints;
}
export declare class GoogleBigQueryConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): GoogleBigQueryConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): GoogleBigQueryConnectorProfile;
    private static readonly defaultTokenEndpoint;
    constructor(scope: Construct, id: string, props: GoogleBigQueryConnectorProfileProps);
    protected buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
}
