"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleAnalytics4Source = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
/**
 * A class that represents a Google Analytics v4 Source
 */
class GoogleAnalytics4Source {
    constructor(props) {
        this.props = props;
        /**
         * The AppFlow type of the connector that this source is implemented for
         */
        this.connectorType = type_1.GoogleAnalytics4ConnectorType.instance;
    }
    bind(scope) {
        this.tryAddNodeDependency(scope, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            apiVersion: this.props.apiVersion,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        return {
            customConnector: {
                entityName: this.props.object,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.GoogleAnalytics4Source = GoogleAnalytics4Source;
_a = JSII_RTTI_SYMBOL_1;
GoogleAnalytics4Source[_a] = { fqn: "@cdklabs/cdk-appflow.GoogleAnalytics4Source", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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