"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleAnalytics4ConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
class GoogleAnalytics4ConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, {
            arn,
        });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, {
            name,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.GoogleAnalytics4ConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                oAuth2Properties: {
                    // INFO: even if we're using a refresh token grant flow this property is required
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.AUTHORIZATION_CODE,
                    // INFO: even if we provide only the access token this property is required
                    // TODO: think about if this is correct. token can be IResolvable
                    tokenUrl: properties.oAuth.endpoints?.token ??
                        GoogleAnalytics4ConnectorProfile.defaultTokenEndpoint,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    // INFO: when using Refresh Token Grant Flow - access token property is required
                    accessToken: properties.oAuth.accessToken?.unsafeUnwrap() ?? "dummyAccessToken",
                    refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken?.unsafeUnwrap(),
                    clientId: properties.oAuth.flow?.refreshTokenGrant.clientId?.unsafeUnwrap(),
                    clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret?.unsafeUnwrap(),
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.GoogleAnalytics4ConnectorProfile = GoogleAnalytics4ConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
GoogleAnalytics4ConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.GoogleAnalytics4ConnectorProfile", version: "0.2.1" };
GoogleAnalytics4ConnectorProfile.defaultTokenEndpoint = "https://oauth2.googleapis.com/token";
//# sourceMappingURL=data:application/json;base64,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