"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleAdsSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
/**
 * A class that represents a Google Ads v4 Source
 */
class GoogleAdsSource {
    constructor(props) {
        this.props = props;
        /**
         * The AppFlow type of the connector that this source is implemented for
         */
        this.connectorType = type_1.GoogleAdsConnectorType.instance;
    }
    bind(scope) {
        this.tryAddNodeDependency(scope, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            apiVersion: this.props.apiVersion,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        return {
            customConnector: {
                entityName: this.props.object,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.GoogleAdsSource = GoogleAdsSource;
_a = JSII_RTTI_SYMBOL_1;
GoogleAdsSource[_a] = { fqn: "@cdklabs/cdk-appflow.GoogleAdsSource", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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