import { CfnFlow } from "aws-cdk-lib/aws-appflow";
import { GoogleAdsConnectorProfile } from "./profile";
import { ConnectorType } from "../core/connectors/connector-type";
import { IFlow } from "../core/flows";
import { ISource } from "../core/vertices";
/**
 * Properties of a Google Ads Source
 */
export interface GoogleAdsSourceProps {
    readonly profile: GoogleAdsConnectorProfile;
    readonly apiVersion: string;
    readonly object: string;
}
/**
 * A class that represents a Google Ads v4 Source
 */
export declare class GoogleAdsSource implements ISource {
    private readonly props;
    /**
     * The AppFlow type of the connector that this source is implemented for
     */
    readonly connectorType: ConnectorType;
    constructor(props: GoogleAdsSourceProps);
    bind(scope: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
