"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleAdsConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
class GoogleAdsConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, {
            arn,
        });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, {
            name,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.GoogleAdsConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                profileProperties: {
                    developerToken: properties.developerToken.unsafeUnwrap(),
                    apiVersion: properties.apiVersion,
                    managerID: properties.managerID?.unsafeUnwrap() /* can be undefined */,
                },
                oAuth2Properties: {
                    // INFO: even if we're using a refresh token grant flow this property is required
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.AUTHORIZATION_CODE,
                    // INFO: even if we provide only the access token this property is required
                    tokenUrl: properties.oAuth.endpoints?.token ??
                        GoogleAdsConnectorProfile.defaultTokenEndpoint,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    // INFO: when using Refresh Token Grant Flow - access token property is required
                    accessToken: properties.oAuth.accessToken?.unsafeUnwrap() ?? "dummyAccessToken",
                    refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken?.unsafeUnwrap(),
                    clientId: properties.oAuth.flow?.refreshTokenGrant.clientId?.unsafeUnwrap(),
                    clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret?.unsafeUnwrap(),
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.GoogleAdsConnectorProfile = GoogleAdsConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
GoogleAdsConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.GoogleAdsConnectorProfile", version: "0.2.1" };
GoogleAdsConnectorProfile.defaultTokenEndpoint = "https://oauth2.googleapis.com/token";
//# sourceMappingURL=data:application/json;base64,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