"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgeConnectorType = void 0;
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const connector_type_1 = require("../core/connectors/connector-type");
/**
 * @internal
 */
class EventBridgeConnectorType extends connector_type_1.ConnectorType {
    static get instance() {
        if (!EventBridgeConnectorType.actualInstance) {
            EventBridgeConnectorType.actualInstance = new EventBridgeConnectorType();
        }
        return EventBridgeConnectorType.actualInstance;
    }
    constructor() {
        super("EventBridge", false);
    }
    get asProfileConnectorType() {
        return this.name;
    }
}
exports.EventBridgeConnectorType = EventBridgeConnectorType;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9ldmVudGJyaWRnZS90eXBlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBOzs7RUFHRTtBQUNGLHNFQUFrRTtBQUVsRTs7R0FFRztBQUNILE1BQWEsd0JBQXlCLFNBQVEsOEJBQWE7SUFDbEQsTUFBTSxLQUFLLFFBQVE7UUFDeEIsSUFBSSxDQUFDLHdCQUF3QixDQUFDLGNBQWMsRUFBRSxDQUFDO1lBQzdDLHdCQUF3QixDQUFDLGNBQWMsR0FBRyxJQUFJLHdCQUF3QixFQUFFLENBQUM7UUFDM0UsQ0FBQztRQUNELE9BQU8sd0JBQXdCLENBQUMsY0FBYyxDQUFDO0lBQ2pELENBQUM7SUFJRDtRQUNFLEtBQUssQ0FBQyxhQUFhLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDOUIsQ0FBQztJQUVELElBQVcsc0JBQXNCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQztJQUNuQixDQUFDO0NBQ0Y7QUFqQkQsNERBaUJDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDb25uZWN0b3JUeXBlIH0gZnJvbSBcIi4uL2NvcmUvY29ubmVjdG9ycy9jb25uZWN0b3ItdHlwZVwiO1xuXG4vKipcbiAqIEBpbnRlcm5hbFxuICovXG5leHBvcnQgY2xhc3MgRXZlbnRCcmlkZ2VDb25uZWN0b3JUeXBlIGV4dGVuZHMgQ29ubmVjdG9yVHlwZSB7XG4gIHB1YmxpYyBzdGF0aWMgZ2V0IGluc3RhbmNlKCk6IENvbm5lY3RvclR5cGUge1xuICAgIGlmICghRXZlbnRCcmlkZ2VDb25uZWN0b3JUeXBlLmFjdHVhbEluc3RhbmNlKSB7XG4gICAgICBFdmVudEJyaWRnZUNvbm5lY3RvclR5cGUuYWN0dWFsSW5zdGFuY2UgPSBuZXcgRXZlbnRCcmlkZ2VDb25uZWN0b3JUeXBlKCk7XG4gICAgfVxuICAgIHJldHVybiBFdmVudEJyaWRnZUNvbm5lY3RvclR5cGUuYWN0dWFsSW5zdGFuY2U7XG4gIH1cblxuICBwcml2YXRlIHN0YXRpYyBhY3R1YWxJbnN0YW5jZTogQ29ubmVjdG9yVHlwZTtcblxuICBjb25zdHJ1Y3RvcigpIHtcbiAgICBzdXBlcihcIkV2ZW50QnJpZGdlXCIsIGZhbHNlKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgYXNQcm9maWxlQ29ubmVjdG9yVHlwZSgpOiBzdHJpbmcge1xuICAgIHJldHVybiB0aGlzLm5hbWU7XG4gIH1cbn1cbiJdfQ==