"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgeDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
const flows_1 = require("../core/flows");
/**
 * This class represents AppFlow's EventBridge destination
 */
class EventBridgeDestination {
    constructor(props) {
        this.props = props;
        this.compatibleFlows = [flows_1.FlowType.EVENT];
        this.connectorType = type_1.EventBridgeConnectorType.instance;
    }
    bind(flow) {
        if (!this.compatibleFlows.includes(flow.type)) {
            throw new Error(`Flow of type ${flow.type} does not support EventBridge as a destination`);
        }
        this.tryAddNodeDependency(flow, this.props.errorHandling?.errorLocation?.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            eventBridge: {
                object: this.props.partnerBus,
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket?.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling?.failOnFirstError,
                },
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.EventBridgeDestination = EventBridgeDestination;
_a = JSII_RTTI_SYMBOL_1;
EventBridgeDestination[_a] = { fqn: "@cdklabs/cdk-appflow.EventBridgeDestination", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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