"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WriteOperation = exports.WriteOperationType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
var WriteOperationType;
(function (WriteOperationType) {
    WriteOperationType["DELETE"] = "DELETE";
    WriteOperationType["INSERT"] = "INSERT";
    WriteOperationType["UPDATE"] = "UPDATE";
    WriteOperationType["UPSERT"] = "UPSERT";
})(WriteOperationType || (exports.WriteOperationType = WriteOperationType = {}));
class WriteOperation {
    static insert(ids) {
        return new WriteOperation(WriteOperationType.INSERT, ids);
    }
    static delete(ids) {
        return new WriteOperation(WriteOperationType.DELETE, ids);
    }
    static update(ids) {
        return new WriteOperation(WriteOperationType.UPDATE, ids);
    }
    static upsert(ids) {
        return new WriteOperation(WriteOperationType.UPSERT, ids);
    }
    constructor(type, ids) {
        this.type = type;
        this.ids = ids;
    }
}
exports.WriteOperation = WriteOperation;
_a = JSII_RTTI_SYMBOL_1;
WriteOperation[_a] = { fqn: "@cdklabs/cdk-appflow.WriteOperation", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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