"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Validation = exports.ValidationAction = exports.ValidationCondition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const operation_1 = require("./operation");
const tasks_1 = require("./tasks");
/**
 * A representation of a validation condition on a particular field in a flow execution
 */
class ValidationCondition {
    /**
     * Validates whether a particular field in an execution is negative
     * @param field a field for which the validation will be performed
     * @returns a @see ValidationCondition instance
     */
    static isNegative(field) {
        return new ValidationCondition(typeof field === "string" ? field : field.name, "VALIDATE_NON_NEGATIVE");
    }
    /**
     * Validates whether a particular field has no value
     * @param field a field for which the validation will be performed
     * @returns a @see ValidationCondition instance
     */
    static isNull(field) {
        return new ValidationCondition(typeof field === "string" ? field : field.name, "VALIDATE_NON_NULL");
    }
    // TODO: make sure that you understand what's here
    /**
     *
     * @param field a field for which the validation will be performed
     * @returns a @see ValidationCondition instance
     */
    static isNotNull(field) {
        return new ValidationCondition(typeof field === "string" ? field : field.name, "VALIDATE_NUMERIC");
    }
    // TODO: make sure that you understand what's here
    /**
     *
     * @param field a field for which the validation will be performed
     * @returns a @see ValidationCondition instance
     */
    static isDefault(field) {
        return new ValidationCondition(typeof field === "string" ? field : field.name, "VALIDATE_NON_ZERO");
    }
    constructor(field, validation) {
        this.field = field;
        this.validation = validation;
    }
}
exports.ValidationCondition = ValidationCondition;
_a = JSII_RTTI_SYMBOL_1;
ValidationCondition[_a] = { fqn: "@cdklabs/cdk-appflow.ValidationCondition", version: "0.2.1" };
class ValidationAction {
    /**
     *
     * @returns a @see ValidationAction that removes a record from the flow execution result
     */
    static ignoreRecord() {
        return new ValidationAction("DropRecord");
    }
    /**
     *
     * @returns a @see ValidationAction that terminates the whole flow execution
     */
    static terminateFlow() {
        return new ValidationAction("DropDataset");
    }
    constructor(action) {
        this.action = action;
    }
}
exports.ValidationAction = ValidationAction;
_b = JSII_RTTI_SYMBOL_1;
ValidationAction[_b] = { fqn: "@cdklabs/cdk-appflow.ValidationAction", version: "0.2.1" };
/**
 * A representation of a validation operation, that is an operation testing records and acting on the test results
 */
class Validation extends operation_1.OperationBase {
    /**
     *
     * @param condition a @see ValidationCondition for the validation
     * @param action a @see ValidationAction for the validation
     * @returns a Validation instance
     */
    static when(condition, action) {
        return new Validation(condition, action);
    }
    constructor(condition, action) {
        super([
            new tasks_1.Task("Validate", [condition.field], { operation: condition.validation }, [{ key: "VALIDATION_ACTION", value: action.action }]),
        ]);
        this.condition = condition;
        this.action = action;
    }
}
exports.Validation = Validation;
_c = JSII_RTTI_SYMBOL_1;
Validation[_c] = { fqn: "@cdklabs/cdk-appflow.Validation", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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