import { Field } from "./field";
import { IOperation, OperationBase } from "./operation";
/**
 * A representation of a validation condition on a particular field in a flow execution
 */
export declare class ValidationCondition {
    readonly field: string;
    readonly validation: string;
    /**
     * Validates whether a particular field in an execution is negative
     * @param field a field for which the validation will be performed
     * @returns a @see ValidationCondition instance
     */
    static isNegative(field: string | Field): ValidationCondition;
    /**
     * Validates whether a particular field has no value
     * @param field a field for which the validation will be performed
     * @returns a @see ValidationCondition instance
     */
    static isNull(field: string | Field): ValidationCondition;
    /**
     *
     * @param field a field for which the validation will be performed
     * @returns a @see ValidationCondition instance
     */
    static isNotNull(field: string | Field): ValidationCondition;
    /**
     *
     * @param field a field for which the validation will be performed
     * @returns a @see ValidationCondition instance
     */
    static isDefault(field: string | Field): ValidationCondition;
    protected constructor(field: string, validation: string);
}
export declare class ValidationAction {
    readonly action: string;
    /**
     *
     * @returns a @see ValidationAction that removes a record from the flow execution result
     */
    static ignoreRecord(): ValidationAction;
    /**
     *
     * @returns a @see ValidationAction that terminates the whole flow execution
     */
    static terminateFlow(): ValidationAction;
    protected constructor(action: string);
}
/**
 * A representation of a validation operation, that is an operation testing records and acting on the test results
 */
export interface IValidation extends IOperation {
}
/**
 * A representation of a validation operation, that is an operation testing records and acting on the test results
 */
export declare class Validation extends OperationBase implements IValidation {
    readonly condition: ValidationCondition;
    readonly action: ValidationAction;
    /**
     *
     * @param condition a @see ValidationCondition for the validation
     * @param action a @see ValidationAction for the validation
     * @returns a Validation instance
     */
    static when(condition: ValidationCondition, action: ValidationAction): IValidation;
    protected constructor(condition: ValidationCondition, action: ValidationAction);
}
