"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Transform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const operation_1 = require("./operation");
const tasks_1 = require("./tasks");
const OP_NOOP = "NO_OP";
/**
 * A representation of a transform operation, that is an operation modifying source fields
 */
class Transform extends operation_1.OperationBase {
    /**
     * Truncates the field to a specified length
     * @param field a source field to truncate
     * @param length the maximum length after truncation
     * @returns a @see Transform instance
     */
    static truncate(field, length) {
        if (!Number.isInteger(length)) {
            throw new Error("length has to be an integer value");
        }
        if (length <= 0) {
            throw new Error("length has to be a positive integer value");
        }
        return new Transform([
            new tasks_1.Task("Truncate", [typeof field === "string" ? field : field.name], { operation: OP_NOOP }, [{ key: "TRUNCATE_LENGTH", value: `${length}` }]),
        ]);
    }
    /**
     * Masks the field with a specified mask
     * @param field a source field to mask
     * @param mask a mask character. @default '*'
     * @returns a @see Transform instance
     */
    static mask(field, mask = "*") {
        if (mask && mask.length !== 1) {
            throw new Error("The mask has to be a single character");
        }
        return new Transform([
            new tasks_1.Task("Mask", [typeof field === "string" ? field : field.name], { operation: "MASK_ALL" }, [
                {
                    // TODO: test this. The AWS Console generated transform has length, but what for?
                    key: "MASK_LENGTH",
                    value: "5",
                },
                { key: "MASK_VALUE", value: mask ?? "*" },
            ]),
        ]);
    }
    static maskStart(field, length, mask) {
        if (!Number.isInteger(length)) {
            throw new Error("length has to be an integer value");
        }
        if (length <= 0) {
            throw new Error("length has to be a positive integer value");
        }
        if (mask && mask.length !== 1) {
            throw new Error("The mask has to be a single character");
        }
        return new Transform([
            new tasks_1.Task("Mask", [typeof field === "string" ? field : field.name], { operation: "MASK_FIRST_N" }, [
                { key: "MASK_LENGTH", value: `${length}` },
                { key: "MASK_VALUE", value: mask ?? "*" },
            ]),
        ]);
    }
    static maskEnd(field, length, mask) {
        if (!Number.isInteger(length)) {
            throw new Error("length has to be an integer value");
        }
        if (length <= 0) {
            throw new Error("length has to be a positive integer value");
        }
        if (mask && mask.length !== 1) {
            throw new Error("The mask has to be a single character");
        }
        return new Transform([
            new tasks_1.Task("Mask", [typeof field === "string" ? field : field.name], { operation: "MASK_LAST_N" }, [
                { key: "MASK_LENGTH", value: `${length}` },
                { key: "MASK_VALUE", value: mask ?? "*" },
            ]),
        ]);
    }
}
exports.Transform = Transform;
_a = JSII_RTTI_SYMBOL_1;
Transform[_a] = { fqn: "@cdklabs/cdk-appflow.Transform", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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