import { Field } from "./field";
import { IOperation, OperationBase } from "./operation";
/**
 * A representation of a transform operation, that is an operation modifying source fields
 */
export interface ITransform extends IOperation {
}
/**
 * A representation of a transform operation, that is an operation modifying source fields
 */
export declare class Transform extends OperationBase implements ITransform {
    /**
     * Truncates the field to a specified length
     * @param field a source field to truncate
     * @param length the maximum length after truncation
     * @returns a @see Transform instance
     */
    static truncate(field: string | Field, length: number): ITransform;
    /**
     * Masks the field with a specified mask
     * @param field a source field to mask
     * @param mask a mask character. @default '*'
     * @returns a @see Transform instance
     */
    static mask(field: string | Field, mask?: string): ITransform;
    static maskStart(field: string | Field, length: number, mask?: string): ITransform;
    static maskEnd(field: string | Field, length: number, mask?: string): ITransform;
}
